import sql from 'mssql';
import { config } from './config.js';

const insertAuthor = async (firstName, lastName, birthDate) => {
  try {
    // Connect to the database
    await sql.connect(config);

    // Execute the insert statement
    await sql.query`INSERT INTO Authors (FirstName, LastName, BirthDate) 
                        VALUES (${firstName}, ${lastName}, ${birthDate})`;

    console.log(`The author ${firstName} ${lastName} was inserted!`);
  } catch (err) {
    console.error('Error inserting new author:', err);
  } finally {
    // Close the database connection
    await sql.close();
  }
};

export { insertAuthor };
